<?php
$tuning_slider_sc = tuning_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $tuning_slider_sc ) && strpos( $tuning_slider_sc, '[' ) !== false && strpos( $tuning_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( tuning_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$tuning_anchor_icon = tuning_get_theme_option( 'front_page_title_anchor_icon' );
		$tuning_anchor_text = tuning_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $tuning_anchor_icon ) || ! empty( $tuning_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $tuning_anchor_icon ) ? ' icon="' . esc_attr( $tuning_anchor_icon ) . '"' : '' )
									. ( ! empty( $tuning_anchor_text ) ? ' title="' . esc_attr( $tuning_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $tuning_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$tuning_scheme = tuning_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $tuning_scheme ) && ! tuning_is_inherit( $tuning_scheme ) ) {
			echo ' scheme_' . esc_attr( $tuning_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( tuning_get_theme_option( 'front_page_title_paddings' ) );
		if ( tuning_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$tuning_css      = '';
		$tuning_bg_image = tuning_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $tuning_bg_image ) ) {
			$tuning_css .= 'background-image: url(' . esc_url( tuning_get_attachment_url( $tuning_bg_image ) ) . ');';
		}
		if ( ! empty( $tuning_css ) ) {
			echo ' style="' . esc_attr( $tuning_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$tuning_anchor_icon = tuning_get_theme_option( 'front_page_title_anchor_icon' );
		$tuning_anchor_text = tuning_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $tuning_anchor_icon ) || ! empty( $tuning_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $tuning_anchor_icon ) ? ' icon="' . esc_attr( $tuning_anchor_icon ) . '"' : '' )
									. ( ! empty( $tuning_anchor_text ) ? ' title="' . esc_attr( $tuning_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( tuning_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' tuning-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$tuning_css      = '';
			$tuning_bg_mask  = tuning_get_theme_option( 'front_page_title_bg_mask' );
			$tuning_bg_color_type = tuning_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $tuning_bg_color_type ) {
				$tuning_bg_color = tuning_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $tuning_bg_color_type ) {
				$tuning_bg_color = tuning_get_scheme_color( 'bg_color', $tuning_scheme );
			} else {
				$tuning_bg_color = '';
			}
			if ( ! empty( $tuning_bg_color ) && $tuning_bg_mask > 0 ) {
				$tuning_css .= 'background-color: ' . esc_attr(
					1 == $tuning_bg_mask ? $tuning_bg_color : tuning_hex2rgba( $tuning_bg_color, $tuning_bg_mask )
				) . ';';
			}
			if ( ! empty( $tuning_css ) ) {
				echo ' style="' . esc_attr( $tuning_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$tuning_caption = tuning_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $tuning_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $tuning_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $tuning_caption, 'tuning_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$tuning_description = tuning_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $tuning_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $tuning_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $tuning_description ), 'tuning_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( tuning_get_theme_option( 'front_page_title_button1_link' ) != '' || tuning_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						tuning_show_layout( tuning_customizer_partial_refresh_front_page_title_button1_link() );
						tuning_show_layout( tuning_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
